import { world, BlockPermutation } from '@minecraft/server';

world.beforeEvents.worldInitialize.subscribe(eventData => {
    eventData.blockTypeRegistry.registerCustomComponent('v360:end_log', {
        onPlayerInteract(e) {
            const { block, player } = e;

            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if (!selectedItem?.hasTag('minecraft:is_axe')) return;
            const blockState = block.permutation.getState("minecraft:block_face");
            if (blockState) {
                const strippedLog = BlockPermutation.resolve('v360:stripped_end_log', { "minecraft:block_face": blockState });
                block.setPermutation(strippedLog);
            }
        }
    });
});